/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.gadgets.entity;

import io.github.fabricators_of_create.porting_lib.entity.IEntityAdditionalSpawnData;
import io.github.fabricators_of_create.porting_lib.entity.PortingLibEntity;
import net.fabricmc.fabric.api.entity.EntityPickInteractionAware;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1533;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.gadgets.entity.FrameType;
import slimeknights.tconstruct.library.utils.Util;

public class FancyItemFrameEntity
extends class_1533
implements EntityPickInteractionAware,
IEntityAdditionalSpawnData {
    private static final int DIAMOND_TIMER = 300;
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(FancyItemFrameEntity.class, (class_2941)class_2943.field_13327);
    private static final String TAG_VARIANT = "Variant";
    private static final String TAG_ROTATION_TIMER = "RotationTimer";
    private int rotationTimer = 0;

    public FancyItemFrameEntity(class_1299<? extends FancyItemFrameEntity> type, class_1937 level) {
        super(type, level);
    }

    public FancyItemFrameEntity(class_1937 levelIn, class_2338 blockPos, class_2350 face, FrameType variant) {
        super((class_1299)TinkerGadgets.itemFrameEntity.get(), levelIn);
        this.field_7100 = blockPos;
        this.method_6892(face);
        this.field_6011.method_12778(VARIANT, (Object)variant.getId());
    }

    private static boolean doesRotate(int type) {
        return type == FrameType.GOLD.getId() || type == FrameType.REVERSED_GOLD.getId() || type == FrameType.DIAMOND.getId();
    }

    public void updateRotationTimer(boolean overturn) {
        this.rotationTimer = overturn ? -300 : 0;
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (!player.method_5715() && this.getFrameId() == FrameType.CLEAR.getId() && !this.method_6940().method_7960()) {
            class_1269 result;
            class_2338 behind = this.method_24515().method_10093(this.field_7099.method_10153());
            class_2680 state = this.method_37908().method_8320(behind);
            if (!state.method_26215() && (result = state.method_26174(this.method_37908(), player, hand, Util.createTraceResult(behind, this.field_7099, false))).method_23665()) {
                return result;
            }
        }
        return super.method_5688(player, hand);
    }

    public void method_5773() {
        super.method_5773();
        int frameId = this.getFrameId();
        if (frameId == FrameType.DIAMOND.getId()) {
            ++this.rotationTimer;
            if (this.rotationTimer >= 300) {
                int curRotation;
                this.rotationTimer = 0;
                if (!this.method_37908().field_9236 && (curRotation = this.method_6934()) > 0) {
                    this.method_6939(curRotation - 1);
                }
            }
            return;
        }
        if (!this.method_37908().field_9236 && FancyItemFrameEntity.doesRotate(frameId)) {
            ++this.rotationTimer;
            if (this.rotationTimer >= 20) {
                this.rotationTimer = 0;
                int curRotation = this.method_6934();
                if (frameId == FrameType.REVERSED_GOLD.getId()) {
                    if (--curRotation == -1) {
                        curRotation = 7;
                    }
                    this.method_6939(curRotation);
                } else {
                    this.method_6939(curRotation + 1);
                }
            }
        }
    }

    public void method_6933(class_1799 stack, boolean updateComparator) {
        super.method_6933(stack, updateComparator);
        if (updateComparator && !this.method_37908().field_9236 && FancyItemFrameEntity.doesRotate(this.getFrameId())) {
            this.method_6941(0, false);
        }
    }

    private void setRotationRaw(int rotationIn, boolean updateComparator) {
        this.method_5841().method_12778(field_7132, (Object)rotationIn);
        if (updateComparator) {
            this.method_37908().method_8455(this.field_7100, class_2246.field_10124);
        }
    }

    protected void method_6941(int rotationIn, boolean updateComparator) {
        this.rotationTimer = 0;
        if (this.getFrameId() == FrameType.DIAMOND.getId()) {
            if (!this.method_37908().field_9236 && updateComparator) {
                this.method_5783(Sounds.ITEM_FRAME_CLICK.getSound(), 1.0f, 1.0f);
            }
            this.setRotationRaw(Math.min(rotationIn, 16), updateComparator);
        } else {
            this.setRotationRaw(rotationIn % 8, updateComparator);
        }
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(VARIANT, (Object)0);
    }

    public FrameType getFrameType() {
        return FrameType.byId(this.getFrameId());
    }

    public class_1792 getFrameItem() {
        return (class_1792)TinkerGadgets.itemFrame.get((Enum)this.getFrameType());
    }

    protected int getFrameId() {
        return (Integer)this.field_6011.method_12789(VARIANT);
    }

    protected class_1799 method_33340() {
        return new class_1799((class_1935)this.getFrameItem());
    }

    public class_1799 getPickedStack(class_1657 player, class_239 target) {
        class_1799 held = this.method_6940();
        if (held.method_7960()) {
            return new class_1799((class_1935)this.getFrameItem());
        }
        return held.method_7972();
    }

    public boolean method_5753() {
        return super.method_5753() || this.getFrameId() == FrameType.NETHERITE.getId();
    }

    public boolean method_5659() {
        return super.method_5659() || this.getFrameId() == FrameType.NETHERITE.getId();
    }

    public int method_6938() {
        if (this.method_6940().method_7960()) {
            return 0;
        }
        int rotation = this.method_6934();
        if (this.getFrameId() == FrameType.DIAMOND.getId()) {
            return Math.min(15, rotation + 1);
        }
        return rotation % 8 + 1;
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        int frameId = this.getFrameId();
        compound.method_10569(TAG_VARIANT, frameId);
        if (FancyItemFrameEntity.doesRotate(frameId)) {
            compound.method_10569(TAG_ROTATION_TIMER, this.rotationTimer);
        }
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        int frameId = compound.method_10550(TAG_VARIANT);
        this.field_6011.method_12778(VARIANT, (Object)frameId);
        if (FancyItemFrameEntity.doesRotate(frameId)) {
            this.rotationTimer = compound.method_10550(TAG_ROTATION_TIMER);
        }
    }

    public class_2596<class_2602> method_18002() {
        return PortingLibEntity.getEntitySpawningPacket((class_1297)this);
    }

    public void writeSpawnData(class_2540 buffer) {
        buffer.method_10804(this.getFrameId());
        buffer.method_10807(this.field_7100);
        buffer.method_10804(this.field_7099.method_10146());
    }

    public void readSpawnData(class_2540 buffer) {
        this.field_6011.method_12778(VARIANT, (Object)buffer.method_10816());
        this.field_7100 = buffer.method_10811();
        this.method_6892(class_2350.method_10143((int)buffer.method_10816()));
    }

    protected class_2561 method_23315() {
        return class_2561.method_43471((String)this.getFrameItem().method_7876());
    }
}

